/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.service;

import filenet.vw.api.VWSystemAdministration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class VWConfigRuntimeOptionsPane
extends JPanel
implements ActionListener {
    protected JCheckBox m_enableLoopDetectionCheckBox = null;
    protected JCheckBox m_removeTimerCheckBox = null;
    protected JCheckBox m_removeParentCheckBox = null;
    protected JCheckBox m_enableConsistentReturnCheckBox = null;
    protected JCheckBox m_enableStatisticsCheckBox = null;
    protected JCheckBox m_enableNotificationCheckBox = null;
    protected JCheckBox m_enableWFTerminationEventCheckBox = null;
    protected JCheckBox m_enableProcessAnalysisCheckBox = null;
    protected JCheckBox m_enableRulesCheckBox = null;
    protected JCheckBox m_allowAsyncRulesCheckBox = null;
    private VWSystemAdministration m_sysAdmin = null;
    private int m_systemWideFlags = 0;
    private Frame m_parentFrame = null;

    public VWConfigRuntimeOptionsPane(Frame parentFrame, VWSystemAdministration sysAdmin, VWSessionInfo sessionInfo) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_sysAdmin = sysAdmin;
            this.setLayout(new BorderLayout(6, 6));
            this.add((Component)this.createOptionsPanel(sessionInfo), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean update() {
        try {
            if (this.m_enableLoopDetectionCheckBox.isSelected()) {
                this.m_systemWideFlags |= 1;
            } else if ((this.m_systemWideFlags & 1) == 1) {
                this.m_systemWideFlags ^= 1;
            }
            if (this.m_removeTimerCheckBox.isSelected()) {
                this.m_systemWideFlags |= 2;
            } else if ((this.m_systemWideFlags & 2) == 2) {
                this.m_systemWideFlags ^= 2;
            }
            if (this.m_removeParentCheckBox.isSelected()) {
                this.m_systemWideFlags |= 4;
            } else if ((this.m_systemWideFlags & 4) == 4) {
                this.m_systemWideFlags ^= 4;
            }
            if (this.m_enableConsistentReturnCheckBox.isSelected()) {
                this.m_systemWideFlags |= 0x200;
            } else if ((this.m_systemWideFlags & 0x200) == 512) {
                this.m_systemWideFlags ^= 0x200;
            }
            if (!this.m_enableNotificationCheckBox.isSelected()) {
                this.m_systemWideFlags |= 0x40;
            } else if ((this.m_systemWideFlags & 0x40) == 64) {
                this.m_systemWideFlags ^= 0x40;
            }
            if (!this.m_enableStatisticsCheckBox.isSelected()) {
                this.m_systemWideFlags |= 0x10;
            } else if ((this.m_systemWideFlags & 0x10) == 16) {
                this.m_systemWideFlags ^= 0x10;
            }
            if (!this.m_enableWFTerminationEventCheckBox.isSelected()) {
                this.m_systemWideFlags |= 0x20;
            } else if ((this.m_systemWideFlags & 0x20) == 32) {
                this.m_systemWideFlags ^= 0x20;
            }
            if (!this.m_enableProcessAnalysisCheckBox.isSelected()) {
                this.m_systemWideFlags |= 0x100;
            } else if ((this.m_systemWideFlags & 0x100) == 256) {
                this.m_systemWideFlags ^= 0x100;
            }
            if (this.m_enableRulesCheckBox.isSelected()) {
                this.m_systemWideFlags |= 0x400;
            } else if ((this.m_systemWideFlags & 0x400) == 1024) {
                this.m_systemWideFlags ^= 0x400;
            }
            if (this.m_allowAsyncRulesCheckBox.isSelected()) {
                this.m_systemWideFlags |= 0x800;
            } else if ((this.m_systemWideFlags & 0x800) == 2048) {
                this.m_systemWideFlags ^= 0x800;
            }
            this.m_sysAdmin.setSystemFlags(this.m_systemWideFlags);
            return true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
            return false;
        }
    }

    public void releaseResources() {
        if (this.m_enableLoopDetectionCheckBox != null) {
            this.m_enableLoopDetectionCheckBox.removeAll();
            this.m_enableLoopDetectionCheckBox = null;
        }
        if (this.m_removeTimerCheckBox != null) {
            this.m_removeTimerCheckBox.removeAll();
            this.m_removeTimerCheckBox = null;
        }
        if (this.m_removeParentCheckBox != null) {
            this.m_removeParentCheckBox.removeAll();
            this.m_removeParentCheckBox = null;
        }
        if (this.m_enableConsistentReturnCheckBox != null) {
            this.m_enableConsistentReturnCheckBox.removeAll();
            this.m_enableConsistentReturnCheckBox = null;
        }
        if (this.m_enableStatisticsCheckBox != null) {
            this.m_enableStatisticsCheckBox.removeAll();
            this.m_enableStatisticsCheckBox = null;
        }
        if (this.m_enableNotificationCheckBox != null) {
            this.m_enableNotificationCheckBox.removeAll();
            this.m_enableNotificationCheckBox = null;
        }
        if (this.m_enableWFTerminationEventCheckBox != null) {
            this.m_enableWFTerminationEventCheckBox.removeAll();
            this.m_enableWFTerminationEventCheckBox = null;
        }
        if (this.m_enableProcessAnalysisCheckBox != null) {
            this.m_enableProcessAnalysisCheckBox.removeActionListener(this);
            this.m_enableProcessAnalysisCheckBox.removeAll();
            this.m_enableProcessAnalysisCheckBox = null;
        }
        if (this.m_enableRulesCheckBox != null) {
            this.m_enableRulesCheckBox.removeActionListener(this);
            this.m_enableRulesCheckBox.removeAll();
            this.m_enableRulesCheckBox = null;
        }
        if (this.m_allowAsyncRulesCheckBox != null) {
            this.m_allowAsyncRulesCheckBox.removeAll();
            this.m_allowAsyncRulesCheckBox = null;
        }
        this.m_sysAdmin = null;
        this.m_parentFrame = null;
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_enableProcessAnalysisCheckBox)) {
            if (this.m_enableProcessAnalysisCheckBox.isSelected()) {
                String rosterRequiredFields = "\tF_StartTime\n\tF_WorkflowNumber\n\tF_TrackerStatus";
                String logRequiredFields = "\tF_EnqueueTime\n\tF_StartTime\n\tF_TrackerStatus\n\tF_WFDeadline\n\tF_WorkflowNumber\n\tF_UniqueId";
                String msg = VWResource.ProcessAnalyerConfigMsg.toString(rosterRequiredFields, logRequiredFields);
                Dimension dim = VWStringUtils.stringToDimension("555,355");
                if (dim == null) {
                    dim = new Dimension(500, 320);
                }
                VWMessageDialog.showOptionDialog(this.m_parentFrame, msg, null, 2, 8, null, dim.width, dim.height);
            }
        } else if (event.getSource().equals(this.m_enableRulesCheckBox)) {
            if (!this.m_enableRulesCheckBox.isSelected()) {
                this.m_allowAsyncRulesCheckBox.setSelected(false);
                this.m_allowAsyncRulesCheckBox.setEnabled(false);
            } else {
                this.m_allowAsyncRulesCheckBox.setEnabled(true);
            }
        }
    }

    protected JPanel createOptionsPanel(VWSessionInfo sessionInfo) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(10, 10));
        panel.add((Component)this.createOptionsPanelTop(sessionInfo), "Center");
        Color bgColor = panel.getBackground();
        JTextArea noteTextArea = new JTextArea();
        noteTextArea.setBackground(bgColor);
        noteTextArea.setEditable(false);
        noteTextArea.setLineWrap(true);
        noteTextArea.setWrapStyleWord(true);
        noteTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        panel.add((Component)noteTextArea, "Last");
        panel.applyComponentOrientation(this.m_parentFrame.getComponentOrientation());
        noteTextArea.append(VWResource.NoteSystemWideConfigRuntime);
        return panel;
    }

    private JPanel createOptionsPanelTop(VWSessionInfo sessionInfo) {
        JPanel mainPanel = null;
        try {
            boolean bFullBPM = sessionInfo.getDisplayFullBPMFunctionality();
            this.initControls(bFullBPM);
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            gbConst.weighty = 0.0;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.anchor = 23;
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.insets = new Insets(4, 10, 4, 4);
            mainPanel.add((Component)this.m_enableLoopDetectionCheckBox, gbConst);
            ++gbConst.gridy;
            mainPanel.add((Component)this.m_removeTimerCheckBox, gbConst);
            ++gbConst.gridy;
            mainPanel.add((Component)this.m_removeParentCheckBox, gbConst);
            ++gbConst.gridy;
            mainPanel.add((Component)this.m_enableConsistentReturnCheckBox, gbConst);
            ++gbConst.gridx;
            gbConst.gridy = 0;
            mainPanel.add((Component)this.m_enableNotificationCheckBox, gbConst);
            ++gbConst.gridy;
            mainPanel.add((Component)this.m_enableWFTerminationEventCheckBox, gbConst);
            if (bFullBPM) {
                ++gbConst.gridy;
                mainPanel.add((Component)this.m_enableProcessAnalysisCheckBox, gbConst);
                ++gbConst.gridy;
                mainPanel.add((Component)this.m_enableRulesCheckBox, gbConst);
                ++gbConst.gridy;
                mainPanel.add((Component)this.m_allowAsyncRulesCheckBox, gbConst);
            }
            ++gbConst.gridy;
            gbConst.weightx = 1.0;
            gbConst.weighty = 1.0;
            gbConst.gridwidth = 0;
            mainPanel.add(Box.createVerticalStrut(100), gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    private boolean initControls(boolean bFullBPM) {
        try {
            this.m_systemWideFlags = this.m_sysAdmin.getSystemWideFlags();
            boolean bFlag = false;
            if ((this.m_systemWideFlags & 1) == 1) {
                bFlag = true;
            }
            this.m_enableLoopDetectionCheckBox = new JCheckBox(VWResource.EnableLoopDetection, bFlag);
            bFlag = false;
            if ((this.m_systemWideFlags & 2) == 2) {
                bFlag = true;
            }
            this.m_removeTimerCheckBox = new JCheckBox(VWResource.RemoveExpiredTimerFromParent, bFlag);
            bFlag = false;
            if ((this.m_systemWideFlags & 4) == 4) {
                bFlag = true;
            }
            this.m_removeParentCheckBox = new JCheckBox(VWResource.DeleteParentChildrenNotMerge, bFlag);
            bFlag = false;
            if ((this.m_systemWideFlags & 0x200) == 512) {
                bFlag = true;
            }
            this.m_enableConsistentReturnCheckBox = new JCheckBox(VWResource.EnableConsistentReturn, bFlag);
            bFlag = false;
            this.m_enableStatisticsCheckBox = new JCheckBox(VWResource.EnableStatistics, bFlag);
            bFlag = true;
            if ((this.m_systemWideFlags & 0x40) == 64) {
                bFlag = false;
            }
            this.m_enableNotificationCheckBox = new JCheckBox(VWResource.EnableNotification, bFlag);
            bFlag = true;
            if ((this.m_systemWideFlags & 0x20) == 32) {
                bFlag = false;
            }
            this.m_enableWFTerminationEventCheckBox = new JCheckBox(VWResource.EnableWFTerminationEvent, bFlag);
            bFlag = true;
            if ((this.m_systemWideFlags & 0x100) == 256) {
                bFlag = false;
            }
            this.m_enableProcessAnalysisCheckBox = new JCheckBox(VWResource.EnableProcessAnalysis, bFlag && bFullBPM);
            this.m_enableProcessAnalysisCheckBox.addActionListener(this);
            bFlag = false;
            if ((this.m_systemWideFlags & 0x400) == 1024) {
                bFlag = true;
            }
            this.m_enableRulesCheckBox = new JCheckBox(VWResource.EnableRules, bFlag && bFullBPM);
            this.m_enableRulesCheckBox.addActionListener(this);
            bFlag = false;
            if ((this.m_systemWideFlags & 0x800) == 2048) {
                bFlag = true;
            }
            this.m_allowAsyncRulesCheckBox = new JCheckBox(VWResource.AllowAsyncRules, bFlag && bFullBPM);
            this.m_allowAsyncRulesCheckBox.setEnabled(this.m_enableRulesCheckBox.isSelected());
            return true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }
}

